using UnityEngine;
using System.Collections;

[RequireComponent (typeof (Detonator))]
[AddComponentMenu("Detonator/Force")]
public class DetonatorForce : DetonatorComponent {

	private float _baseRadius = 50.0f;
	private float _basePower = 4000.0f;
	private float _scaledRange;
	private float _scaledIntensity;
	private bool _delayedExplosionStarted = false;
	private float _explodeDelay;
	
	public float radius;
	public float power;
	public GameObject fireObject;
	public float fireObjectLife;
	
	private Collider[] _colliders;
	private GameObject _tempFireObject;
	
	override public void Init()
	{
		//unused
	}

	void Update()
	{
		if (_delayedExplosionStarted)
		{
			_explodeDelay = (_explodeDelay - Time.deltaTime);
			if (_explodeDelay <= 0f)
			{
				Explode();
			}
		}
	}
	
	private Vector3 _explosionPosition;
	
	override public void Explode()
	{
		if (!on) return;
		if (detailThreshold > detail) return;	
		
		if (!_delayedExplosionStarted)
		{
			_explodeDelay = explodeDelayMin + (Random.value * (explodeDelayMax - explodeDelayMin));
		}
		if (_explodeDelay <= 0) //if the delayTime is zero
		{
			_explosionPosition = transform.position;
			_colliders = Physics.OverlapSphere (_explosionPosition, radius);
			
			foreach (Collider hit in _colliders) 
			{
				if (!hit)
				{
					continue;
				}
				
				if (hit.rigidbody)
				{
					hit.rigidbody.AddExplosionForce((power * size), _explosionPosition, (radius * size), (3.0f * size));
					
					//and light them on fire for Rune
					if (fireObject)
					{
						_tempFireObject = (Instantiate(fireObject, this.transform.position, this.transform.rotation)) as GameObject;
						_tempFireObject.transform.parent = hit.transform;
						_tempFireObject.transform.localPosition = new Vector3(0f,0f,0f);
						if (_tempFireObject.particleEmitter)
						{
							_tempFireObject.particleEmitter.emit = true;
							Destroy(_tempFireObject,fireObjectLife);
						}
					}
				}
			}
			_delayedExplosionStarted = false;
			_explodeDelay = 0f;
		}
		else
		{
			//tell update to start reducing the start delay and call explode again when it's zero
			_delayedExplosionStarted = true;
		}
	}
	
	public void Reset()
	{
		radius = _baseRadius;
		power = _basePower;
	}
}

