﻿using UnityEngine;
using System.Collections;

public class CharacterTargeting : MonoBehaviour
{
    public LookController headLook;
    public Texture2D crosshairTexture;
    private Vector2 mousePos;
    public LayerMask aimingMask;

    private Camera mainCamera;

    private Vector3 lookAtPoint = Vector3.zero;



    void Start()
    {
        mainCamera = transform.parent.transform.GetComponent<Camera>();

        //aimingMask = LayerMask.NameToLayer("asdf");

    }


    void OnGUI()
    {




        //create crosshair graphic to follow mouse position
        mousePos = Event.current.mousePosition;

        GUI.DrawTexture(new Rect(mousePos.x - (crosshairTexture.width / 2),
                           mousePos.y - (crosshairTexture.height / 2),
                           crosshairTexture.width,
                           crosshairTexture.height), crosshairTexture);
    }


    void Update()
    {

        Ray mouseCameraRay = mainCamera.ScreenPointToRay(Input.mousePosition);
       
        

       // Ray mouseProjectRay = new Ray(mouseWorldPos, mainCamera.transform.forward);
       


        RaycastHit hit;

        if (Physics.Raycast(mouseCameraRay, out hit, 500, aimingMask))
            lookAtPoint = hit.point;

       headLook.target = lookAtPoint;

       Debug.DrawRay(mainCamera.transform.position, mouseCameraRay.direction* 500, Color.blue);

       
    }

}



