﻿using UnityEngine;
using System.Collections;

public class DaylightTime : MonoBehaviour
{
    //15 degrees is equal to an hour of time. multiply by time to slow down rotation amount
    float timeChange = 15.0f * 0.03f;
    public Material skyBoxMat;

    private GameObject character;
    private GameObject sunlight;

    private float materialBlendValue = 0.5f;

    void Start()
    {
        character = GameObject.Find("Player");
        sunlight = GameObject.Find("sunlight");


    }


    // Update is called once per frame
    void Update()
    {


        transform.Rotate(0, timeChange * Time.deltaTime, 0);


        //determine skybox texture depending on player's position
        float materialAngleDifference = Vector3.Angle(character.transform.up, -sunlight.transform.forward);
        //Debug.Log(materialAngleDifference);


        // float materialBlendValue = materialAngleDifference / 180.0f;


        if (materialAngleDifference < 65)
        {
            materialBlendValue = Mathf.Lerp(materialBlendValue, 1.0f, Time.deltaTime * 0.5f);
            skyBoxMat.SetFloat("_Blend", materialBlendValue);
            Debug.Log(materialAngleDifference);

        }

        else if (materialAngleDifference >= 110)
        {
            materialBlendValue = Mathf.Lerp(materialBlendValue, 0.0f, Time.deltaTime * 0.5f);
            skyBoxMat.SetFloat("_Blend", materialBlendValue);
        }
        else
        {
            //materialBlendValue = materialAngleDifference / 180.0f;
            materialBlendValue = Mathf.Lerp(materialBlendValue, 0.5f, Time.deltaTime * 0.5f);
            skyBoxMat.SetFloat("_Blend", materialBlendValue);
        }

    }
}
        
        
        


