﻿using UnityEngine;
using System.Collections;

public class Missile : MonoBehaviour
{

    public GameObject explosionPrefab;
    public float PowerLength = 10.0f;
    public Vector3 startingForce;
    

    private float startTime;
    private float outOfFuel;
    private Vector3 gravityDirection;
    private Vector3 missileForceDifference;
    
    void Start()
    {
        rigidbody.useGravity = false;

        startTime = Time.time;
        outOfFuel = startTime + PowerLength;


        Collider targetCollider = GameObject.Find("Hit Target Vertical").collider;
        Physics.IgnoreCollision(this.gameObject.collider, targetCollider);
       
    }

  


    void Update()
    {

        Debug.Log(Time.time + "  " + outOfFuel);

        if (Time.time < outOfFuel)
          rigidbody.AddRelativeForce(startingForce);
        else

        
        gravityDirection = -transform.position.normalized;
        
        rigidbody.AddForce(gravityDirection * 20);
        rigidbody.AddRelativeTorque(new Vector3(0,2.8f,18.5f));


       
    }




    void OnCollisionEnter(Collision coll)
    {

        ContactPoint contact = coll.contacts[0];

        Vector3 collRotation = new Vector3(contact.normal.x * 360, contact.normal.y * 360, contact.normal.z * 360);

        if (coll.gameObject.name != "Player" && coll.gameObject.name != "Hit Target Vertical")
        {
            Debug.Log(Quaternion.Euler(collRotation));

            GameObject.Instantiate(explosionPrefab, transform.position, Quaternion.Euler(collRotation));
            Destroy(this.gameObject, 0.1f);
        }
    }

}
