﻿using UnityEngine;
using System.Collections;

public class ThirdPersonPlayerAnimation : MonoBehaviour
{
public float runSpeedScale = 1.0f;
public float walkSpeedScale = 1.0f;

public GameObject bazookaMissile;

private PlatformCharacterController platformCharController;
private PhysicsCharacterMotor phsxMotor;


    void Start ()
{
	// By default loop all animations
	animation.wrapMode = WrapMode.Loop;

	animation["run"].layer = -1;
	animation["walk"].layer = -1;
	animation["idle"].layer = -2;
	animation.SyncLayer(-1);




	// The jump animation is clamped and overrides all others
	animation["jump"].layer = 10;
	animation["jump"].wrapMode = WrapMode.ClampForever;

	animation["fall"].layer = 10;	
	animation["fall"].wrapMode = WrapMode.Loop;

	animation["land"].layer = 10;	
	animation["land"].wrapMode = WrapMode.Once;




    Transform waist = GameObject.Find("upper.torso").transform;
    //Transform root = GameObject.Find("butt").transform;

    // bazooka weapon animations
    animation["bazookaFire"].layer = 12;
    animation["bazookaFire"].wrapMode = WrapMode.Once;
    animation["bazookaFire"].AddMixingTransform(waist);
    animation["bazookaFire"].normalizedSpeed = 1.0f;


    animation["bazookaHold"].layer = 12;
    animation["bazookaHold"].wrapMode = WrapMode.ClampForever;

    animation["bazookaHold"].weight = 1.0f;
    animation["bazookaHold"].AddMixingTransform(waist);




	// We are in full control here - don't let any other animations play when we start
	animation.Stop();
	animation.Play("idle");


    platformCharController = GetComponent<PlatformCharacterController>();
    phsxMotor = GetComponent<PhysicsCharacterMotor>();
    
}



void Update ()
{


        if (phsxMotor.grounded)
        {
            animation.Blend("fall", 0.0f, 0.3f);
            animation.Blend("jump", 0.0f, 0.3f);

            //Fade in Run
            if (rigidbody.velocity.magnitude > phsxMotor.maxForwardSpeed - 1)
            {
                animation.CrossFade("run");

                //fade out walk
                animation.Blend("walk", 0.0f, 0.3f);
            }

            // Fade in walk
            else if (rigidbody.velocity.magnitude > (phsxMotor.maxForwardSpeed * platformCharController.walkMultiplier - 1))
            {

                animation.CrossFade("walk");

                // We fade out jumpland realy quick otherwise we get sliding feet
                animation.Blend("run", 0.0f, 0.3f);

            }

            // Fade out walk and run so just idle remains
            else
            {
                animation.Blend("walk", 0.0f, 0.3f);
                animation.Blend("run", 0.0f, 0.3f);
                animation.Blend("bazookaHold", 0.0f, 0.3f);


            }


  


            animation["run"].normalizedSpeed = runSpeedScale;
            animation["walk"].normalizedSpeed = walkSpeedScale;

        }



        if (phsxMotor.jumping)
        {


            if (!phsxMotor.jumpingReachedApex && phsxMotor.jumping)
            {
                animation.CrossFade("jump", 0.2f);
                animation.Blend("fall", 0.0f, 0.3f);
            }

            else
            {
                animation.Blend("jump", 0.0f, 0.3f);
                animation.CrossFade("fall", 0.2f);

            }


            animation.Blend("walk", 0.0f, 0.1f);
            animation.Blend("run", 0.0f, 0.1f);

        }

        if (Weapons.usingWeapon == "bazooka")
        {
            animation.Blend("bazookaHold", 1.0f);

        }




    
}

public void DidLand () {
	animation.Play("land");
}


//sent from Weapon.cs when Bazooka fired
//blend out holding holding animation and blend in fire animation
public void BazookaFire()
{
    animation.Blend("bazookaHold", 0.0f, 0.1f);
    animation.Blend("bazookaFire", 1.0f, 0.1f);
}






}//end class