﻿using UnityEngine;
using System.Collections;

public class Weapons : MonoBehaviour
{
    public GameObject bazooka;

    public GameObject bazookaMissile;
    
    
   public static string usingWeapon = "none";
   public static float bazookaFireDelay = 1.1f;
   public GameObject shootingHand;

    private Transform shootingArm;
    
    private PhysicsCharacterMotor phsxMotor;
    private PlatformCharacterController platformController;
   
    // Use this for initialization
    void Start()
    {
        shootingArm = GameObject.Find("right.arm").transform;
        

        // used to stop player when firing bazooka
        phsxMotor = GetComponent<PhysicsCharacterMotor>();
        platformController = GetComponent<PlatformCharacterController>();

        AnimationEvent bazookaEvent = new AnimationEvent();
        bazookaEvent.functionName = "bazookaFireEvent";
        bazookaEvent.time = 0.4f;
        animation.GetClip("bazookaFire").AddEvent(bazookaEvent);

    }

    // Update is called once per frame
    void Update()
    {

        Debug.DrawRay(GameObject.Find("BazookaBarrel").transform.position, GameObject.Find("BazookaBarrel").transform.forward*10);

        if (Input.GetKeyDown(KeyCode.Alpha1) && usingWeapon != "bazooka")
        {
           
            usingWeapon = "bazooka";

            //detaches the bazooka from waist and moves it to arm
            bazooka.transform.parent = null;

            bazooka.transform.position = shootingHand.transform.position;
            bazooka.transform.parent = shootingHand.transform;

            // bazooka.transform.position = shootingArm.position;
            //bazooka.transform.parent = shootingArm;

            //locally position bazooka so it is oriented right
            bazooka.transform.localPosition = new Vector3(-0.2f, 1.33f, -0.8f);
            bazooka.transform.localRotation = Quaternion.Euler(368, 42.4f, -7.6f);
            
        }

        if (Input.GetKeyDown(KeyCode.Alpha0) )
        {

            usingWeapon = "none";

            //removes bazooka from hand and puts it back on back
            bazooka.transform.parent = null;
            bazooka.transform.position = GameObject.Find("lower.torso").transform.position;
            bazooka.transform.parent = GameObject.Find("lower.torso").transform;

            //locally position bazooka so it is oriented right (equipped)
            bazooka.transform.localPosition = new Vector3(-5, 0, -2.8f);
            bazooka.transform.localRotation = Quaternion.Euler(-75, 190, 0);

            
          
        }


        if (Input.GetButtonDown("Fire") && (bazookaFireDelay >= 1.0f) && (phsxMotor.rigidbody.velocity.magnitude < (platformController.walkMultiplier*phsxMotor.maxForwardSpeed)) && usingWeapon == "bazooka")
        {
            //makes sure you can't fire too many missiles at once
            bazookaFireDelay = 0.01f;

            SendMessage("BazookaFire");

        
            
        }


        if (bazookaFireDelay >= 0.01f)
        {
            bazookaFireDelay += Time.deltaTime;
        }

    }

    public void bazookaFireEvent()
    {
        Vector3 MissilePos = GameObject.Find("BazookaBarrel").transform.position;
        Vector3 MissileRot = GameObject.Find("BazookaBarrel").transform.forward;

        Instantiate(bazookaMissile, MissilePos, Quaternion.LookRotation(MissileRot));
    }
} //end class
